<Material name="carbon_fiber" version="1.0">
    <MetaData >
        <Property formalName="Environment Map" name="uEnvironmentTexture" description="Environment texture for the material" type="Texture" filter="linear" minfilter="linearMipmapLinear" clamp="repeat" usage="environment" default="./maps/materials/spherical_checker.png" category="Material"/>
        <Property formalName="Enable Environment" name="uEnvironmentMappingEnabled" description="Enable environment mapping" type="Boolean" default="True" category="Material"/>
        <Property formalName="Baked Shadow Map" name="uBakedShadowTexture" description="Baked shadow texture for the material" type="Texture" filter="linear" minfilter="linearMipmapLinear" clamp="repeat" usage="shadow" default="./maps/materials/shadow.png" category="Material"/>
        <Property formalName="Shadow Mapping" name="uShadowMappingEnabled" description="Enable shadow mapping" type="Boolean" default="False" category="Material"/>
        <Property formalName="Coat ior" name="coat_ior" type="Float" default="1.250000" description="Index of refraction of the coating layer" category="Material"/>
        <Property formalName="Coat Glossy weight" name="coat_weight" type="Float" min="0.000000" max="1.000000" default="1.000000" description="Strength of the coating's glossy reflection.\n0 = no reflection\n1 = maximum reflectivity" category="Material"/>
        <Property formalName="Coat Roughness" name="coat_roughness" type="Float" min="0.000000" max="1.000000" default="0.000000" description="Roughness of the material.\n0 = fully specular\n1 = fully diffuse" category="Material"/>
        <Property formalName="Base ior" name="base_ior" type="Float" default="1.650000" description="Index of refraction of the material" category="Material"/>
        <Property formalName="Glossy Weight" name="base_weight" type="Float" min="0.000000" max="1.000000" default="0.500000" description="Strength of glossy reflection at incident angles.\n0 = no reflection\n1 = maximum reflectivity" category="Material"/>
        <Property formalName="Roughness" name="base_roughness" type="Float" min="0.000000" max="1.000000" default="0.100000" description="Roughness of the material.\n0 = fully specular\n1 = fully diffuse" category="Material"/>
        <Property formalName="Anisotropy" name="anisotropy" type="Float" min="0.000000" max="0.999000" default="0.800000" description="The anisotropy of the roughness" category="Material"/>
        <Property formalName="Anisotropy Map" description="Anisotropy transformation texture" name="anisotropy_rotation_texture" type="Texture" filter="linear" minfilter="linear" clamp="repeat" usage="anisotropy" default="./maps/materials/carbon_fiber_aniso.png" category="Material"/>
        <Property formalName="Tiling" name="texture_tiling" type="Float2" default="12 12" description="Scaling of the textures" category="Material"/>
        <Property formalName="Reflectivity Map" name="reflect_texture" description="Reflectivity texture for the material" type="Texture" filter="linear" minfilter="linearMipmapLinear" clamp="repeat" usage="specular" default="./maps/materials/carbon_fiber_spec.png" category="Material"/>
        <Property formalName="Diffuse Map" name="diffuse_texture" description="Diffuse texture of the material" type="Texture" filter="linear" minfilter="linearMipmapLinear" clamp="repeat" usage="diffuse" default="./maps/materials/carbon_fiber.png" category="Material"/>
        <Property formalName="Bump Map" name="bump_texture" description="Bump texture of the material" type="Texture" filter="linear" minfilter="linearMipmapLinear" clamp="repeat" usage="bump" default="./maps/materials/carbon_fiber_bump.png" category="Material"/>
        <Property formalName="Bump Amount" name="bump_amount" type="Float" default="1.000000" description="Value determining the bumpiness" category="Material"/>
    </MetaData>
    <Shaders type="GLSL" version="330">
    <Shader>
    <Shared>    </Shared>
<VertexShader>
        </VertexShader>
        <FragmentShader>

// add enum defines
#define scatter_reflect 0
#define scatter_transmit 1
#define scatter_reflect_transmit 2
#define mono_alpha 0
#define mono_average 1
#define mono_luminance 2
#define mono_maximum 3
#define wrap_clamp 0
#define wrap_repeat 1
#define wrap_mirrored_repeat 2
#define gamma_default 0
#define gamma_linear 1
#define gamma_srgb 2

#define QT3DS_ENABLE_UV0 1
#define QT3DS_ENABLE_WORLD_POSITION 1
#define QT3DS_ENABLE_TEXTAN 1
#define QT3DS_ENABLE_BINORMAL 1

#include "vertexFragmentBase.glsllib"

// set shader output
out vec4 fragColor;

// add structure defines
struct layer_result
{
  vec4 base;
  vec4 layer;
  mat3 tanFrame;
};


struct texture_coordinate_info
{
  vec3 position;
  vec3 tangent_u;
  vec3 tangent_v;
};


struct anisotropy_return
{
  float roughness_u;
  float roughness_v;
  vec3 tangent_u;
};


struct texture_return
{
  vec3 tint;
  float mono;
};


// temporary declarations
texture_coordinate_info tmp0;
texture_coordinate_info tmp1;
texture_coordinate_info tmp2;
texture_coordinate_info tmp3;
anisotropy_return tmp4;
vec3 tmp6;
float ftmp0;
float ftmp1;
vec3 ftmp2;
vec3 ftmp3;
vec3 ftmp4;
 vec4 tmpShadowTerm;

layer_result layers[3];

#include "SSAOCustomMaterial.glsllib"
#include "sampleLight.glsllib"
#include "sampleProbe.glsllib"
#include "sampleArea.glsllib"
#include "square.glsllib"
#include "calculateRoughness.glsllib"
#include "evalBakedShadowMap.glsllib"
#include "evalEnvironmentMap.glsllib"
#include "luminance.glsllib"
#include "microfacetBSDF.glsllib"
#include "physGlossyBSDF.glsllib"
#include "simpleGlossyBSDF.glsllib"
#include "monoChannel.glsllib"
#include "fileBumpTexture.glsllib"
#include "transformCoordinate.glsllib"
#include "rotationTranslationScale.glsllib"
#include "textureCoordinateInfo.glsllib"
#include "fileTexture.glsllib"
#include "anisotropyConversion.glsllib"
#include "weightedLayer.glsllib"
#include "diffuseReflectionBSDF.glsllib"
#include "fresnelLayer.glsllib"

bool evalTwoSided()
{
  return( false );
}

vec3 computeFrontMaterialEmissive()
{
  return( vec3( 0, 0, 0 ) );
}

void computeFrontLayerColor( in vec3 normal, in vec3 lightDir, in vec3 viewDir, in vec3 lightDiffuse, in vec3 lightSpecular, in float materialIOR, float aoFactor )
{
#if QT3DS_ENABLE_CG_LIGHTING
  layers[0].layer += tmpShadowTerm * microfacetBSDF( layers[0].tanFrame, lightDir, viewDir, lightSpecular, materialIOR, coat_roughness, coat_roughness, scatter_reflect );

  layers[1].layer += tmpShadowTerm * microfacetBSDF( layers[1].tanFrame, lightDir, viewDir, lightSpecular, materialIOR, ftmp0, ftmp1, scatter_reflect );

  layers[2].base += tmpShadowTerm * vec4( 0.0, 0.0, 0.0, 1.0 );
  layers[2].layer += tmpShadowTerm * diffuseReflectionBSDF( tmp6, lightDir, lightDiffuse );

#endif
}

void computeFrontAreaColor( in int lightIdx, in vec4 lightDiffuse, in vec4 lightSpecular )
{
#if QT3DS_ENABLE_CG_LIGHTING
  layers[0].layer += tmpShadowTerm * lightSpecular * sampleAreaGlossy( layers[0].tanFrame, varWorldPos, lightIdx, viewDir, coat_roughness, coat_roughness );

  layers[1].layer += tmpShadowTerm * lightSpecular * sampleAreaGlossy( layers[1].tanFrame, varWorldPos, lightIdx, viewDir, ftmp0, ftmp1 );

  layers[2].base += tmpShadowTerm * vec4( 0.0, 0.0, 0.0, 1.0 );
  layers[2].layer += tmpShadowTerm * lightDiffuse * sampleAreaDiffuse( layers[2].tanFrame, varWorldPos, lightIdx );

#endif
}

void computeFrontLayerEnvironment( in vec3 normal, in vec3 viewDir, float aoFactor )
{
#if !QT3DS_ENABLE_LIGHT_PROBE
  layers[0].layer += tmpShadowTerm * microfacetSampledBSDF( layers[0].tanFrame, viewDir, coat_roughness, coat_roughness, scatter_reflect );

  layers[1].layer += tmpShadowTerm * microfacetSampledBSDF( layers[1].tanFrame, viewDir, ftmp0, ftmp1, scatter_reflect );

  layers[2].base += tmpShadowTerm * vec4( 0.0, 0.0, 0.0, 1.0 );
  layers[2].layer += tmpShadowTerm * diffuseReflectionBSDFEnvironment( tmp6, 0.000000 ) * aoFactor;

#else
  layers[0].layer += tmpShadowTerm * sampleGlossy( layers[0].tanFrame, viewDir, coat_roughness );

  layers[1].layer += tmpShadowTerm * sampleGlossy( layers[1].tanFrame, viewDir, ftmp0 );

  layers[2].base += tmpShadowTerm * vec4( 0.0, 0.0, 0.0, 1.0 );
  layers[2].layer += tmpShadowTerm * sampleDiffuse( layers[2].tanFrame ) * aoFactor;

#endif
}

vec3 computeBackMaterialEmissive()
{
  return( vec3(0, 0, 0) );
}

void computeBackLayerColor( in vec3 normal, in vec3 lightDir, in vec3 viewDir, in vec3 lightDiffuse, in vec3 lightSpecular, in float materialIOR, float aoFactor )
{
#if QT3DS_ENABLE_CG_LIGHTING
  layers[0].base += vec4( 0.0, 0.0, 0.0, 1.0 );
  layers[0].layer += vec4( 0.0, 0.0, 0.0, 1.0 );
#endif
}

void computeBackAreaColor( in int lightIdx, in vec4 lightDiffuse, in vec4 lightSpecular )
{
#if QT3DS_ENABLE_CG_LIGHTING
  layers[0].base += vec4( 0.0, 0.0, 0.0, 1.0 );
  layers[0].layer += vec4( 0.0, 0.0, 0.0, 1.0 );
#endif
}

void computeBackLayerEnvironment( in vec3 normal, in vec3 viewDir, float aoFactor )
{
#if !QT3DS_ENABLE_LIGHT_PROBE
  layers[0].base += vec4( 0.0, 0.0, 0.0, 1.0 );
  layers[0].layer += vec4( 0.0, 0.0, 0.0, 1.0 );
#else
  layers[0].base += vec4( 0.0, 0.0, 0.0, 1.0 );
  layers[0].layer += vec4( 0.0, 0.0, 0.0, 1.0 );
#endif
}

float computeIOR()
{
  return( false ? 1.0 : luminance( vec3( 1, 1, 1 ) ) );
}

float evalCutout()
{
  return( 1.000000 );
}

vec3 computeNormal()
{
  return( normal );
}

void computeTemporaries()
{
    vec3 tiling = vec3( texture_tiling[0], texture_tiling[1], 1.0);
    tmp2 = scaleCoordinate(tiling, textureCoordinateInfo( texcoordTransformed_bump_texture(texCoord0), tangent, binormal ) );
    tmp3 = scaleCoordinate(tiling, textureCoordinateInfo( texcoordTransformed_reflect_texture(texCoord0), tangent, binormal ) );
    tmp1 = scaleCoordinate(tiling, textureCoordinateInfo( texcoordTransformed_diffuse_texture(texCoord0), tangent, binormal ) );
    tmp0 = scaleCoordinate(tiling, textureCoordinateInfo( texcoordTransformed_anisotropy_rotation_texture(texCoord0), tangent, binormal ) );
    tmp4 = anisotropyConversion( base_roughness, anisotropy, fileTexture(anisotropy_rotation_texture, vec3( 0, 0, 0 ), vec3( 3.14, 3.14, 3.14 ), mono_luminance, tmp0, vec2( 0.000000, 1.000000 ), vec2( 0.000000, 1.000000 ), wrap_repeat, wrap_repeat, gamma_linear ).mono, tangent, false );
    tmp6 = fileBumpTexture(bump_texture, bump_amount, mono_average, tmp2, vec2( 0.000000, 1.000000 ), vec2( 0.000000, 1.000000 ), wrap_repeat, wrap_repeat, normal );
    ftmp0 = tmp4.roughness_u;
    ftmp1 = tmp4.roughness_v;
    ftmp2 = fileTexture(reflect_texture, vec3( 0, 0, 0 ), vec3( 1, 1, 1 ), mono_luminance, tmp3, vec2( 0.000000, 1.000000 ), vec2( 0.000000, 1.000000 ), wrap_repeat, wrap_repeat, gamma_linear ).tint;
    ftmp3 = tmp4.tangent_u;
    ftmp4 = fileTexture(diffuse_texture, vec3( 0, 0, 0 ), vec3( 1, 1, 1 ), mono_luminance, tmp1, vec2( 0.000000, 1.000000 ), vec2( 0.000000, 1.000000 ), wrap_repeat, wrap_repeat, gamma_srgb ).tint;
    tmpShadowTerm = evalBakedShadowMap( texCoord0 );
}

vec4 computeLayerWeights( in float alpha )
{
  vec4 color;
  color = weightedLayer( 1.000000, vec4( ftmp4, 1.0).rgb, layers[2].layer, layers[2].base, alpha );
  color = fresnelLayer( tmp6, vec3( base_ior ), base_weight, vec4( ftmp2, 1.0).rgb, layers[1].layer, color, color.a );
  color = fresnelLayer( normal, vec3( coat_ior ), coat_weight, vec4( vec3( 1, 1, 1 ), 1.0).rgb, layers[0].layer, color, color.a );
  return color;
}


void initializeLayerVariables(void)
{
  // clear layers
  layers[0].base = vec4(0.0, 0.0, 0.0, 1.0);
  layers[0].layer = vec4(0.0, 0.0, 0.0, 1.0);
  layers[0].tanFrame = orthoNormalize( mat3( tangent, cross(normal, tangent), normal ) );
  layers[1].base = vec4(0.0, 0.0, 0.0, 1.0);
  layers[1].layer = vec4(0.0, 0.0, 0.0, 1.0);
  layers[1].tanFrame = orthoNormalize( mat3( ftmp3, cross(tmp6, ftmp3), tmp6 ) );
  layers[2].base = vec4(0.0, 0.0, 0.0, 1.0);
  layers[2].layer = vec4(0.0, 0.0, 0.0, 1.0);
  layers[2].tanFrame = orthoNormalize( mat3( tangent, cross(tmp6, tangent), tmp6 ) );
}

        </FragmentShader>
    </Shader>
    </Shaders>
<Passes >
        <ShaderKey value="5"/>
        <LayerKey count="3"/>
    <Pass >
    </Pass>
</Passes>
</Material>
